const tbody = document.querySelector("tbody");
const MAX_ROWS = 200;

async function loadLogs() {
    const res = await fetch("fetch_logs.php");
    const logs = await res.json();

    const fragment = document.createDocumentFragment();

    logs.forEach(log => {
        const tr = document.createElement("tr");
        tr.innerHTML = `
            <td>${log.email}</td>
            <td>${log.ip}</td>
            <td><span class="badge opened">Opened</span></td>
            <td>${log.time}</td>
        `;
        fragment.appendChild(tr);
    });

    tbody.innerHTML = "";
    tbody.appendChild(fragment);
    trimRows();
}

function trimRows() {
    const rows = tbody.querySelectorAll("tr");
    if (rows.length > MAX_ROWS) {
        for (let i = 0; i < rows.length - MAX_ROWS; i++) {
            rows[i].remove();
        }
    }
}

/* Auto refresh every 10s */
setInterval(loadLogs, 10000);
loadLogs();
